<?php
// Start the session to get the user_id
session_start();

// Include the database connection
include('db.php'); // Assuming you have a db.php file for DB connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user']) || !isset($_SESSION['user']['user_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.'
    ]);
    exit;
}

// Get product ID from request
$product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;

if ($product_id <= 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid product ID.'
    ]);
    exit;
}

$user_id = intval($_SESSION['user']['user_id']);

// Query to get cart data for specific product
$query = "
    SELECT 
        c.Cart_id,
        c.Quantity,
        p.Product_id,
        p.Product_name,
        p.Product_image,
        p.Selling_price,
        p.MRP
    FROM 
        cart c
    INNER JOIN 
        product p ON c.Product_id = p.Product_id 
    WHERE 
        c.User_id = '$user_id' 
        AND c.Product_id = '$product_id'
        AND c.Delete_status = 0
        AND p.mode = 1 
        AND p.Delete_status = 0
    LIMIT 1
";

$result = mysqli_query($conn, $query);

if ($result && mysqli_num_rows($result) > 0) {
    $cart_item = mysqli_fetch_assoc($result);
    
    echo json_encode([
        'status' => 'success',
        'data' => [
            'cart_id' => $cart_item['Cart_id'],
            'product_id' => $cart_item['Product_id'],
            'product_name' => $cart_item['Product_name'],
            'product_image' => $cart_item['Product_image'],
            'selling_price' => $cart_item['Selling_price'],
            'mrp' => $cart_item['MRP'],
            'quantity' => $cart_item['Quantity']
        ]
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Product not found in cart.'
    ]);
}

// Close the database connection
mysqli_close($conn);
?>